/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package data.structures.corpus;

import data.base.Database;
import data.base.connectors.CorpusDatabase;
import data.base.connectors.RSSFeedDatabase;

import java.util.Vector;

public class ClusteringCorpusGraph {
    private CorpusGraphLemmaItem[] gitems;

    public ClusteringCorpusGraph(Database db, int taille){
        CorpusDatabase cDB = new CorpusDatabase(db);
        try{
            RSSFeedDatabase fDB = new RSSFeedDatabase(db);
            Vector<CorpusItem> items = cDB.createClusteringCorpus(taille);
            gitems = new CorpusGraphLemmaItem[items.size()];
            for(int i=0; i<gitems.length; i++){
                gitems[i] = new CorpusGraphLemmaItem();
                gitems[i].setNodeID(i);
                gitems[i].setNodeName(items.elementAt(i).getRSSItemTitle());
                gitems[i].setLemmas(fDB.getNameLemmas(items.elementAt(i).getIdItem()));
                // La thématique n'est pas utilisée ici.
                gitems[i].setThematique("");
                gitems[i].setIdThematique(0);
            }
        } catch(data.base.NoBaseException nbe) {
            gitems = new CorpusGraphLemmaItem[0];
        }
    }

    public CorpusGraphLemmaItem[] getItems(){
        return gitems;
    }
}
